/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.webapp;

import com.imagedecoder.TIFFImageProducer;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MediaServlet
extends HttpServlet {
    private File m_mediaBaseFile;
    private List m_readFormats;
    private List m_writeFormats;

    public void init(ServletConfig servletConfig) throws ServletException {
        File mediaBaseFile;
        String propertiesFileName;
        File propertiesFile;
        super.init(servletConfig);
        String mediaBase = null;
        if (mediaBase == null || "".equals(mediaBase.trim())) {
            mediaBase = System.getProperty("interparts-cd.media-base");
        }
        if ((mediaBase == null || "".equals(mediaBase.trim())) && (propertiesFile = new File(propertiesFileName = this.getServletContext().getRealPath("WEB-INF/mediaservlet.properties"))).exists() && propertiesFile.canRead()) {
            try {
                FileInputStream inputStream = new FileInputStream(propertiesFile);
                Properties properties = new Properties();
                properties.load(inputStream);
                mediaBase = servletConfig.getInitParameter("media-base");
            }
            catch (IOException ioException) {
                // empty catch block
            }
        }
        if (mediaBase == null || "".equals(mediaBase.trim())) {
            mediaBase = servletConfig.getServletContext().getRealPath("");
        }
        if (!(mediaBaseFile = new File(mediaBase)).isAbsolute()) {
            File webappBase = new File(servletConfig.getServletContext().getRealPath(""));
            mediaBaseFile = new File(webappBase, mediaBaseFile.toString());
        }
        this.m_mediaBaseFile = mediaBaseFile;
        System.out.println("Media Base: " + this.m_mediaBaseFile);
        String[] readFormats = ImageIO.getReaderMIMETypes();
        String[] writeFormats = ImageIO.getWriterMIMETypes();
        this.m_readFormats = Arrays.asList(readFormats);
        this.m_writeFormats = Arrays.asList(writeFormats);
        System.out.println("Image Readers: " + this.m_readFormats);
        System.out.println("Image Writers: " + this.m_writeFormats);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handle(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handle(httpServletRequest, httpServletResponse);
    }

    private void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            String servletPath = httpServletRequest.getServletPath();
            try {
                if (servletPath != null) {
                    File localFile = null;
                    String convertPath = httpServletRequest.getParameter("convert");
                    if (convertPath != null) {
                        servletPath = convertPath;
                    }
                    localFile = new File(this.getServletContext().getRealPath(servletPath));
                    String convertTo = httpServletRequest.getParameter("to");
                    System.out.println("Trying local file: " + localFile);
                    if (localFile.exists() && localFile.canRead()) {
                        this.output(localFile, httpServletResponse, convertTo);
                        return;
                    }
                    File remoteFile = new File(this.m_mediaBaseFile, servletPath);
                    System.out.println("Trying remote file: " + remoteFile);
                    if (remoteFile.exists() && remoteFile.canRead()) {
                        this.output(remoteFile, httpServletResponse, convertTo);
                        return;
                    }
                }
            }
            catch (IOException ioExcpetion) {
                // empty catch block
            }
            System.err.println("Could not out output " + servletPath);
            httpServletResponse.sendError(404, "File not found");
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void output(File file, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        System.out.println("Outputting file: " + file);
        long length = file.length();
        httpServletResponse.setContentLength((int)length);
        String contentType = this.getServletContext().getMimeType(file.getName());
        httpServletResponse.setContentType(contentType);
        ServletOutputStream outputStream = httpServletResponse.getOutputStream();
        FileInputStream inputStream = new FileInputStream(file);
        int character = ((InputStream)inputStream).read();
        while (character != -1) {
            outputStream.write((byte)character);
            character = ((InputStream)inputStream).read();
        }
        ((InputStream)inputStream).close();
        outputStream.close();
    }

    private void convert(File file, HttpServletResponse httpServletResponse, String convertTo) throws ServletException, IOException {
        System.out.println("Converting file: " + file + " to " + convertTo);
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage != null) {
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            boolean success = ImageIO.write((RenderedImage)bufferedImage, convertTo, (OutputStream)outputStream);
            if (!success) {
                System.out.println("Cannot export file: " + file + " to format " + convertTo);
            }
            outputStream.close();
        } else {
            System.out.println("Cannot import file: " + file);
        }
    }

    private void convertComplicated(File file, HttpServletResponse httpServletResponse, String convertTo) throws ServletException, IOException {
        String fileExtention = file.getName();
        if (fileExtention.lastIndexOf(".") > -1) {
            fileExtention = fileExtention.substring(fileExtention.lastIndexOf("."));
        }
        Iterator<ImageReader> imageReadersIterator = ImageIO.getImageReadersBySuffix(fileExtention);
        Iterator<ImageWriter> imageWritersIterator = ImageIO.getImageWritersByFormatName(convertTo);
        if (!imageReadersIterator.hasNext() || !imageWritersIterator.hasNext()) {
            System.out.println("Cannot convert file: " + file + " to " + convertTo);
            this.output(file, httpServletResponse);
        } else {
            System.out.println("Converting file: " + file + " to " + convertTo);
            ImageWriter imageWriter = imageWritersIterator.next();
            String mimeType = imageWriter.getOriginatingProvider().getMIMETypes()[0];
            httpServletResponse.setContentType(mimeType);
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            FileInputStream inputStream = new FileInputStream(file);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            ImageIO.write((RenderedImage)bufferedImage, convertTo, (OutputStream)outputStream);
            ((InputStream)inputStream).close();
            outputStream.close();
        }
    }

    private void convertTiff(File file, HttpServletResponse httpServletResponse, String convertTo) throws ServletException, IOException {
        System.out.println("Converting Fax-Encoded-Tiff file: " + file + " to " + convertTo);
        TIFFImageProducer tiffImageProducer = new TIFFImageProducer(file.toURL());
        Image image = Toolkit.getDefaultToolkit().createImage((ImageProducer)tiffImageProducer);
        BufferedImage bufferedImage = (BufferedImage)image.getScaledInstance(image.getHeight(null) * 2, image.getWidth(null) * 2, 2);
        if (bufferedImage != null) {
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            boolean success = ImageIO.write((RenderedImage)bufferedImage, convertTo, (OutputStream)outputStream);
            if (!success) {
                System.out.println("Cannot export file: " + file + " to format " + convertTo);
            }
            outputStream.close();
        } else {
            System.out.println("Cannot import file: " + file);
            this.output(file, httpServletResponse);
        }
    }

    private void output(File file, HttpServletResponse httpServletResponse, String convertTo) throws ServletException, IOException {
        if (convertTo != null) {
            this.convert(file, httpServletResponse, convertTo);
        } else {
            this.output(file, httpServletResponse);
        }
    }
}

